<?php

/* Master theme class */
class Resume_Options {
	
	private $sections;
	private $checkboxes;
	private $settings;
	
	/* Construct */
	public function __construct() {

		// This will keep track of the checkbox options for the validate_settings function.
		$this->checkboxes = array();
		$this->settings = array();
//		$this->get_settings();
		
		$this->sections['style']     = __('Page Style');
		$this->sections['personal']  = __('Personal Info');
		$this->sections['sidebar']   = __('Sidebar');
		$this->sections['foot']    = __('Footer');
		
		add_action( 'admin_menu', array( &$this, 'add_pages' ) );
		add_action( 'admin_init', array( &$this, 'register_settings' ) );
		
		if ( ! get_option( 'resume_options' ) )
			$this->initialize_settings();
		
	}
	
	/* Add options page */
	public function add_pages() {
		
		$admin_page = add_theme_page( __('Paper Resume Options'), __('Resume Options'), 'manage_options', 'resume-options', array(&$this, 'display_page') );
		
		add_action('admin_print_scripts-' . $admin_page, array(&$this, 'scripts'));
		add_action('admin_print_styles-' . $admin_page, array(&$this, 'styles'));
		
	}
	
	/* Create settings field */
	public function create_setting($args = array()) {
		
		$defaults = array(
			'id'      => 'default_field',
			'title'   => __( 'Default Field' ),
			'desc'    => __( 'This is a default description.' ),
			'std'     => '',
			'type'    => 'text',
			'section' => '',
			'choices' => array(),
			'class'   => ''
		);
			
		extract( wp_parse_args( $args, $defaults ) );
		
		$field_args = array(
			'type'      => $type,
			'id'        => $id,
			'desc'      => $desc,
			'std'       => $std,
			'choices'   => $choices,
			'label_for' => $id,
			'class'     => $class
		);
		
		if ( $type == 'checkbox' )
			$this->checkboxes[] = $id;
		
		add_settings_field( $id, $title, array( $this, 'display_setting' ), 'resume-options', $section, $field_args );
	}
	
	/**
	 * Display options page
	 *
	 * @since 1.0
	 */
	public function display_page() {
		
		echo '<div class="wrap">
	<div class="icon32" id="icon-options-general"></div>
	<h2>' . __( 'Theme Options' ) . '</h2>';
	
		if ( isset( $_GET['settings-updated'] ) && $_GET['settings-updated'] == true )
			echo '<div class="updated fade"><p>' . __( 'Theme options updated.' ) . '</p></div>';
		
		echo '<form action="options.php" method="post">';
	
		settings_fields( 'resume_options' );
		echo '<div class="ui-tabs">
			<ul class="ui-tabs-nav">';
		
		foreach ( $this->sections as $section_slug => $section )
			echo '<li><a href="#' . $section_slug . '">' . $section . '</a></li>';
		
		echo '</ul>';
		do_settings_sections( $_GET['page'] );
		
		echo '</div>
		<p class="submit"><input name="Submit" type="submit" class="button-primary" value="' . __( 'Save Changes' ) . '" /></p>
		
	</form>';
	
	echo '<script type="text/javascript">
		jQuery(document).ready(function($) {
			var sections = [];';
			
			foreach ( $this->sections as $section_slug => $section )
				echo "sections['$section'] = '$section_slug';";
			
			echo 'var wrapped = $(".wrap h3").wrap("<div class=\"ui-tabs-panel\">");
			wrapped.each(function() {
				$(this).parent().append($(this).parent().nextUntil("div.ui-tabs-panel"));
			});
			$(".ui-tabs-panel").each(function(index) {
				$(this).attr("id", sections[$(this).children("h3").text()]);
				if (index > 0)
					$(this).addClass("ui-tabs-hide");
			});
			$(".ui-tabs").tabs({
				fx: { opacity: "toggle", duration: "fast" }
			});
			
			$("span.description").each(function() {
				//$(this).parent().siblings("th").children("label").after($(this)).css("display","block");
				$(this).insertAfter($(this).parent().siblings("th").children("label"));
			});
			
			$(".form-table").removeClass().addClass("widefat");
			

			$("h3").remove();
			
			$(".heading").closest("tr").remove();
			
			
			$("input[type=text], textarea").each(function() {
				if ($(this).val() == $(this).attr("placeholder") || $(this).val() == "")
					$(this).css("color", "#999");
			});
			
			$("input[type=text], textarea").focus(function() {
				if ($(this).val() == $(this).attr("placeholder") || $(this).val() == "") {
					$(this).val("");
					$(this).css("color", "#000");
				}
			}).blur(function() {
				if ($(this).val() == "" || $(this).val() == $(this).attr("placeholder")) {
					$(this).val($(this).attr("placeholder"));
					$(this).css("color", "#999");
				}
			});
			
			$(".wrap h3, .wrap table").show();
			
			// This will make the "warning" checkbox class really stand out when checked.
			// I use it here for the Reset checkbox.
			$(".warning").change(function() {
				if ($(this).is(":checked"))
					$(this).parent().css("background", "#c00").css("color", "#fff").css("fontWeight", "bold");
				else
					$(this).parent().css("background", "none").css("color", "inherit").css("fontWeight", "normal");
			});
			
			// Browser compatibility
			if ($.browser.mozilla) 
			         $("form").attr("autocomplete", "off");
		});
	</script>
</div>';
		
	}
	
	/* Description for section */
		public function display_section() {
			// code
		}
	
	/* Description for About section */
		public function display_about_section() {
			// This displays on the "About" tab. Echo regular HTML here, like so:
			// echo '<p>Copyright 2011 me@example.com</p>';
		}
	
	/**
	 * HTML output for text field
	 *
	 * @since 1.0
	 */
	public function display_setting( $args = array() ) {
		
		extract($args);
		
		$options = get_option('resume_options');
		
		if (!isset($options[$id]) && $type != 'checkbox' )
			$options[$id] = $std;
		elseif (!isset($options[$id]))
			$options[$id] = 0;
		
		$field_class = '';
		if ( $class != '' )
			$field_class = ' ' . $class;
		
		switch ( $type ) {
			
			case 'heading':
				
				echo '
				<span class='. $field_class .'></span>
				<thead>
				<tr>
					<th scope="col" colspan="2">' . $desc . '</th> 
				</tr>
				</thead>';
				
				break;
			
			case 'checkbox':
				
				echo '<input class="checkbox' . $field_class . '" type="checkbox" id="' . $id . '" name="resume_options[' . $id . ']" value="1" ' . checked( $options[$id], 1, false ) . ' />'; // <label for="' . $id . '">' . $desc . '</label>
				
				if ( $desc != '' )
					echo '<span class="description">' . $desc . '</span>';
				
				break;
			
			case 'select':
				echo '<select class="select' . $field_class . '" name="resume_options[' . $id . ']">';
				
				foreach ( $choices as $value => $label )
					echo '<option value="' . esc_attr( $value ) . '"' . selected( $options[$id], $value, false ) . '>' . $label . '</option>';
				
				echo '</select> <div class="color"></div>';
				
				if ( $desc != '' )
					echo '<span class="description">' . $desc . '</span>';
				
				break;
			
			case 'radio':
				$i = 0;
				foreach ( $choices as $value => $label ) {
					echo '<input class="radio' . $field_class . '" type="radio" name="resume_options[' . $id . ']" id="' . $id . $i . '" value="' . esc_attr( $value ) . '" ' . checked( $options[$id], $value, false ) . '> <label for="' . $id . $i . '">' . $label . '</label>';
					if ( $i < count( $options ) - 1 )
						echo '<br />';
					$i++;
				}
				
				if ( $desc != '' )
					echo '<span class="description">' . $desc . '</span>';
				
				break;
							
			case 'textarea':
				echo '<textarea class="' . $field_class . '" id="' . $id . '" name="resume_options[' . $id . ']" placeholder="' . $std . '" rows="5" cols="30">' . wp_htmledit_pre( $options[$id] ) . '</textarea>';
				
				if ( $desc != '' )
					echo '<span class="description">' . $desc . '</span>';
				
				break;
			
			case 'password':
				echo '<input class="regular-text' . $field_class . '" type="password" id="' . $id . '" name="resume_options[' . $id . ']" value="' . esc_attr( $options[$id] ) . '" />';
				
				if ( $desc != '' )
					echo '<span class="description">' . $desc . '</span>';
				
				break;
			
			case 'text':
			default:
		 		echo '<input class="regular-text' . $field_class . '" type="text" id="' . $id . '" name="resume_options[' . $id . ']" placeholder="' . $std . '" value="' . esc_attr( $options[$id] ) . '" />';
		 		
		 		if ( $desc != '' )
		 			echo '<span class="description">' . $desc . '</span>';
		 		
		 		break;

		}
		
	}




	
	/**
	 * Settings and defaults
	 * 
	 * @since 1.0
	 */
	public function get_settings() {
				
		/* Page Style
		===========================================*/
		
		$this->settings['heading_background'] = array(
			'section' => 'style',
			'type'    => 'heading',
			'title'   => '',
			'desc'    => 'Background',
			'class'   => 'heading'
		);

		$this->settings['background_image'] = array(
			'section' => 'style',
			'type'    => 'select',
			'title'   => __('Background Image'),
			'desc'    => __('Select your background image.'),
			'choices' => array(
				'light-wood.jpg' => 'Light Wood',
				'dark-wood.jpg'  => 'Dark Wood'
			),
			'std'     => ''
		);
		
		$this->settings['paper'] = array(
			'section' => 'style',
			'type'    => 'select',
			'title'   => __('Paper Type'),
			'desc'    => __('Select your paper type.'),
			'choices' => array(
				'paper/paper-dusty.png' => 'Dusty Paper',
				'paper/paper-math.png'  => 'Math Paper',
				'paper/paper-original.png'  => 'Original Paper'
			),
			'std'     => ''
		);


		$this->settings['heading_labels'] = array(
			'section' => 'style',
			'type'    => 'heading',
			'title'   => '',
			'desc'    => 'Section Label Colors',
			'class'   => 'heading'
		);
		
		/* Colors for Label */
		$color_options = array(
			'retro/red.png'			=> 'Retro Red',
			'retro/pink.png'			=> 'Retro Pink',
			'retro/orange.png'		=> 'Retro Orange',
			'retro/yellow.png'		=> 'Retro Yellow',
			'retro/dark-blue.png'	=> 'Retro Dark Blue',
			'retro/blue.png'  		=> 'Retro Blue',
			'retro/green.png'			=> 'Retro Green',
			'retro/olive.png'			=> 'Retro Olive',
			'retro/black.png'			=> 'Retro Black',
			
			'bold/red.png'				=> 'Bold Red',
			'bold/pink.png'			=> 'Bold Pink',
			'bold/orange.png'			=> 'Bold Orange',
			'bold/green.png'			=> 'Bold Green',
			'bold/dark-green.png'	=> 'Bold Dark Green',
			'bold/blue.png'  			=> 'Bold Blue',
			
			'muted/crimson.png'		=> 'Muted Crimson',
			'muted/vermillion.png'	=> 'Muted Vermillion',
			'muted/gold.png'			=> 'Muted Gold',
			'muted/dark-blue.png'	=> 'Muted Dark Blue',
			'muted/blue.png'			=> 'Muted Blue',
			'muted/green.png'			=> 'Muted Green',
			'muted/olive.png'			=> 'Muted Olive'
		);
		
		$categories = get_categories('orderby=name&hide_empty=0');
		
				
		
		foreach($categories as $key => $category) {

			$this->settings[$category->slug] = array (
					'section' => 'style',
					'type'    => 'select',
					'title'   => __($category->name),
					'desc'    => __('Select a label color.'),
					'choices' => $color_options,
					'std'     => ''
			);
		}

		
	
			

		/* Personal Info
		===========================================*/
		
		/* Page Title & Description */
		
		$this->settings['heading_title'] = array(
			'section' => 'personal',
			'type'    => 'heading',
			'title'   => '',
			'desc'    => 'Page Title & Description',
			'class'   => 'heading'
		);
		
		$this->settings['page_title'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Page Title'),
			'desc'    => __('Example: Jonathan Doe'),
			'std'     => ''
		);
		
		$this->settings['page_description'] = array(
			'section' => 'personal',
			'type'    => 'textarea',
			'title'   => __('Description'),
			'desc'    => __('A few lines about yourself. Be creative.'),
			'std'     => '',
		);
		
		/* Personal Info */
		
		$this->settings['heading_personal'] = array(
			'section' => 'personal',
			'type'    => 'heading',
			'title'   => '',
			'desc'    => 'Personal Info',
			'class'   => 'heading'
		);
		
		$this->settings['full_name'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Full Name'),
			'desc'    => __('Leave this blank if it\'s the same as \'Page Title\''),
			'std'     => ''
		);
		
		$this->settings['date_of_birth'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Date of Birth'),
			'desc'    => __('Example: January 1st, 1970'),
			'std'     => ''
		);
		
		$this->settings['date_of_birth'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Date of Birth'),
			'desc'    => __('Example: January 1st, 1970'),
			'std'     => ''
		);
		
		$this->settings['address'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Address'),
			'desc'    => __('Enter your home address. Or just the city'),
			'std'     => ''
		);
		
		$this->settings['phone_number'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Phone'),
			'desc'    => __('Enter your phone number.'),
			'std'     => ''
		);
		
		$this->settings['email_address'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Email'),
			'desc'    => __('Feel free to mask it (e.g. john.doe[at]gmail.com)'),
			'std'     => ''
		);
	
		/* Contact Form */
		
		$this->settings['heading_contact_form'] = array(
			'section' => 'personal',
			'type'    => 'heading',
			'title'   => '',
			'desc'    => 'Contact Form',
			'class'   => 'heading'
		);
				
		$this->settings['enable_contact_form'] = array(
			'section' => 'personal',
			'type'    => 'checkbox',
			'title'   => __('Enable Contact Form?'),
			'desc'    => __('Leave unchecked if you want to disable it.'),
			'std'     => 0
		);
		
		$this->settings['contact_email_address'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Contact Email'),
			'desc'    => __('Where do you want the emails to go?'),
			'std'     => ''
		);
		
		$this->settings['contact_form_text'] = array(
			'section' => 'personal',
			'type'    => 'textarea',
			'title'   => __('Contact Form Text'),
			'desc'    => __('Optional text above your contact form.'),
			'std'     => '',
		);
		
		/* Websites */
		
		$this->settings['heading_websites'] = array(
			'section' => 'personal',
			'type'    => 'heading',
			'title'   => '',
			'desc'    => 'Websites',
			'class'   => 'heading'
		);
		
		$this->settings['website_label_1'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Website Label 1'),
			'desc'    => __('Example: Blog, Portfolio, Website'),
			'std'     => ''
		);
		
		$this->settings['website_link_1'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Website Link 1'),
			'desc'    => __('Example: http://www.jon-doe.com'),
			'std'     => ''
		);
		
		$this->settings['website_label_2'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Website Label 2'),
			'desc'    => __('Example: Blog, Portfolio, Website'),
			'std'     => ''
		);
		
		$this->settings['website_link_2'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Website Link 2'),
			'desc'    => __('Example: http://www.jon-doe.com'),
			'std'     => ''
		);
		
		$this->settings['website_label_3'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Website Label 3'),
			'desc'    => __('Example: Blog, Portfolio, Website'),
			'std'     => ''
		);
		
		$this->settings['website_link_3'] = array(
			'section' => 'personal',
			'type'    => 'text',
			'title'   => __('Website Link 3'),
			'desc'    => __('Example: http://www.jon-doe.com'),
			'std'     => ''
		);
		
		
		/* Sidebar
		===========================================*/
		
		/* Portrait */
		
		$this->settings['heading_sidebar'] = array(
			'section' => 'sidebar',
			'type'    => 'heading',
			'title'   => '',
			'desc'    => 'Portrait',
			'class'   => 'heading'
		);
		
		$this->settings['portrait_link'] = array(
			'section' => 'sidebar',
			'type'    => 'text',
			'title'   => __('Portrait Link'),
			'desc'    => __('Enter the link to your portrait.'),
			'std'     => ''
		);
		
		/* Social Networks */
		
		$this->settings['heading_social'] = array(
			'section' => 'sidebar',
			'type'    => 'heading',
			'title'   => '',
			'desc'    => 'Social Networks',
			'class'   => 'heading'
		);
		
		$this->settings['facebook'] = array(
			'section' => 'sidebar',
			'type'    => 'text',
			'title'   => __('Facebook'),
			'desc'    => __('Example: http://www.facebook.com/TheBlackKeys'),
			'std'     => ''
		);
		
		$this->settings['twitter'] = array(
			'section' => 'sidebar',
			'type'    => 'text',
			'title'   => __('Twitter'),
			'desc'    => __('Example: http://www.twitter.com/johndoe'),
			'std'     => ''
		);
		
		$this->settings['linkedin'] = array(
			'section' => 'sidebar',
			'type'    => 'text',
			'title'   => __('LinkedIn'),
			'desc'    => __('Example: http://www.linkedin.com/in/johndoe'),
			'std'     => ''
		);
		
		$this->settings['flickr'] = array(
			'section' => 'sidebar',
			'type'    => 'text',
			'title'   => __('Flickr'),
			'desc'    => __('Example: http://www.flickr.com/photos/johndoe'),
			'std'     => ''
		);
		
		$this->settings['youtube'] = array(
			'section' => 'sidebar',
			'type'    => 'text',
			'title'   => __('YouTube'),
			'desc'    => __('Example: http://www.youtube.com/user/johndoe'),
			'std'     => ''
		);
		
		$this->settings['vimeo'] = array(
			'section' => 'sidebar',
			'type'    => 'text',
			'title'   => __('Vimeo'),
			'desc'    => __('Example: http://www.vimeo.com/johndoe'),
			'std'     => ''
		);
		
		/* Other Links */
		
		$this->settings['heading_other_link'] = array(
			'section' => 'sidebar',
			'type'    => 'heading',
			'title'   => '',
			'desc'    => 'Other Links',
			'class'   => 'heading'
		);
		
		$this->settings['vcard'] = array(
			'section' => 'sidebar',
			'type'    => 'text',
			'title'   => __('vCard Link'),
			'desc'    => __('Enter the link to your vCard.'),
			'std'     => ''
		);
		
		$this->settings['show_print_link'] = array(
			'section' => 'sidebar',
			'type'    => 'checkbox',
			'title'   => __('Show Print Link'),
			'desc'    => __('Leave unchecked if you want to hide it.'),
			'std'     => 0
		);
		
		/* Footer
		===========================================*/
		
		/* Stats / Tracker */
		
		$this->settings['heading_footer'] = array(
			'section' => 'foot',
			'type'    => 'heading',
			'title'   => '',
			'desc'    => 'Codes',
			'class'   => 'heading'
		);
		
		$this->settings['tracker_code'] = array(
			'section' => 'foot',
			'type'    => 'textarea',
			'title'   => __('Stats / Tracker Code'),
			'desc'    => __('Enter your tracking code.'),
			'std'     => ''
		);
		
	}
	

	
	/**
	 * Initialize settings to their default values
	 * 
	 * @since 1.0
	 */
	public function initialize_settings() {
		
		$default_settings = array();
		foreach ( $this->settings as $id => $setting ) {
			if ( $setting['type'] != 'heading' )
				$default_settings[$id] = $setting['std'];
		}
		
		update_option( 'resume_options', $default_settings );
		
	}
	
	/**
	* Register settings
	*
	* @since 1.0
	*/
	public function register_settings() {
		
		register_setting( 'resume_options', 'resume_options', array ( &$this, 'validate_settings' ) );
		
		foreach ( $this->sections as $slug => $title ) {
			if ( $slug == 'about' )
				add_settings_section( $slug, $title, array( &$this, 'display_about_section' ), 'resume-options' );
			else
				add_settings_section( $slug, $title, array( &$this, 'display_section' ), 'resume-options' );
		}
		
		$this->get_settings();
		
		foreach ( $this->settings as $id => $setting ) {
			$setting['id'] = $id;
			$this->create_setting( $setting );
		}
		
	}
	
	/**
	* jQuery Tabs
	*
	* @since 1.0
	*/
	public function scripts() {
		wp_print_scripts( 'jquery-ui-tabs' );	
	}
	
	/**
	* Styling for the theme options page
	*
	* @since 1.0
	*/
	public function styles() {
		wp_register_style( 'resume-admin', get_bloginfo( 'stylesheet_directory' ) . '/resume-options.css' );
		wp_enqueue_style( 'resume-admin' );
	}
	
	/**
	* Validate settings
	*
	* @since 1.0
	*/
	public function validate_settings( $input ) {
		
		if ( ! isset( $input['reset_theme'] ) ) {
			$options = get_option( 'resume_options' );
			
			foreach ( $this->checkboxes as $id ) {
				if ( isset( $options[$id] ) && ! isset( $input[$id] ) )
					unset( $options[$id] );
			}
			
			return $input;
		}
		return false;
		
	}
	
}

$theme_options = new Resume_Options();

function resume_option( $option ) {
	$options = get_option( 'resume_options' );
	if ( isset( $options[$option] ) )
		return $options[$option];
	else
		return false;
}
?>