/**
 * @license
 * =========================================================
 * bootstrap-datetimepicker.js
 * http://www.eyecon.ro/bootstrap-datepicker
 * =========================================================
 * Copyright 2012 Stefan Petre
 *
 * Contributions:
 *  - Andrew Rowls
 *  - Thiago de Arruda
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================================================
 */
!function(w){window.orientation;var n=function(t,e){this.id=i++,this.init(t,e)};n.prototype={constructor:n,init:function(t,e){var i,s,a,n,o,r;if(!e.pickTime&&!e.pickDate)throw new Error("Must choose at least one picker");if(this.options=e,this.$element=w(t),this.language=e.language in k?e.language:"en",this.pickDate=e.pickDate,this.pickTime=e.pickTime,this.isInput=this.$element.is("input"),this.component=!1,(this.$element.find(".input-append")||this.$element.find(".input-prepend"))&&(this.component=this.$element.find(".add-on")),this.format=e.format,this.format||(this.isInput?this.format=this.$element.data("format"):this.format=this.$element.find("input").data("format"),this.format||(this.format="MM/dd/yyyy")),this._compileFormat(),this.component&&(i=this.component.find("i")),this.pickTime&&(i&&i.length&&(this.timeIcon=i.data("time-icon")),this.timeIcon||(this.timeIcon="bdticon-time"),i.addClass(this.timeIcon)),this.pickDate&&(i&&i.length&&(this.dateIcon=i.data("date-icon")),this.dateIcon||(this.dateIcon="bdticon-calendar"),i.removeClass(this.timeIcon),i.addClass(this.dateIcon)),this.widget=w((this.timeIcon,s=e.pickDate,a=e.pickTime,n=e.pick12HourFormat,o=e.pickSeconds,r=e.collapse,s&&a?'<div class="bootstrap-datetimepicker-widget dropdown-menu"><ul><li'+(r?' class="collapse in"':"")+'><div class="datepicker">'+T.template+'</div></li><li class="picker-switch accordion-toggle"><a><i class="bdticon-stopwatch"></i></a></li><li'+(r?' class="collapse"':"")+'><div class="timepicker">'+l.getTemplate(n,o)+"</div></li></ul></div>":a?'<div class="bootstrap-datetimepicker-widget dropdown-menu"><div class="timepicker">'+l.getTemplate(n,o)+"</div></div>":'<div class="bootstrap-datetimepicker-widget dropdown-menu"><div class="datepicker">'+T.template+"</div></div>")).appendTo("body"),this.minViewMode=e.minViewMode||this.$element.data("date-minviewmode")||0,"string"==typeof this.minViewMode)switch(this.minViewMode){case"months":this.minViewMode=1;break;case"years":this.minViewMode=2;break;default:this.minViewMode=0}if(this.viewMode=e.viewMode||this.$element.data("date-viewmode")||0,"string"==typeof this.viewMode)switch(this.viewMode){case"months":this.viewMode=1;break;case"years":this.viewMode=2;break;default:this.viewMode=0}this.startViewMode=this.viewMode,this.weekStart=e.weekStart||this.$element.data("date-weekstart")||0,this.weekEnd=0===this.weekStart?6:this.weekStart-1,this.setStartDate(e.startDate||this.$element.data("date-startdate")),this.setEndDate(e.endDate||this.$element.data("date-enddate")),this.fillDow(),this.fillMonths(),this.fillHours(),this.fillMinutes(),this.fillSeconds(),this.update(),this.showMode(),this._attachDatePickerEvents()},show:function(t){this.widget.show(),this.height=this.component?this.component.outerHeight():this.$element.outerHeight(),this.place(),this.$element.trigger({type:"show",date:this._date}),this._attachDatePickerGlobalEvents(),t&&(t.stopPropagation(),t.preventDefault())},disable:function(){this.$element.find("input").prop("disabled",!0),this._detachDatePickerEvents()},enable:function(){this.$element.find("input").prop("disabled",!1),this._attachDatePickerEvents()},hide:function(){for(var t=this.widget.find(".collapse"),e=0;e<t.length;e++){var i=t.eq(e).data("collapse");if(i&&i.transitioning)return}this.widget.hide(),this.viewMode=this.startViewMode,this.showMode(),this.set(),this._detachDatePickerGlobalEvents()},set:function(){var t="";if(this._unset||(t=this.formatDate(this._date)),this.isInput)this.$element.val(t),this._resetMaskPos(this.$element);else{if(this.component){var e=this.$element.find("input");e.val(t),this._resetMaskPos(e)}this.$element.data("date",t)}},setValue:function(t){this._unset=!t,"string"==typeof t?this._date=this.parseDate(t):t&&(this._date=new Date(t)),this.set(),this.viewDate=v(this._date.getUTCFullYear(),this._date.getUTCMonth(),1,0,0,0,0),this.fillDate(),this.fillTime()},getDate:function(){return this._unset?null:new Date(this._date.valueOf())},setDate:function(t){t?this.setValue(t.valueOf()):this.setValue(null)},setStartDate:function(t){t instanceof Date?this.startDate=t:"string"==typeof t?(this.startDate=new v(t),this.startDate.getUTCFullYear()||(this.startDate=-1/0)):this.startDate=-1/0,this.viewDate&&this.update()},setEndDate:function(t){t instanceof Date?this.endDate=t:"string"==typeof t?(this.endDate=new v(t),this.endDate.getUTCFullYear()||(this.endDate=1/0)):this.endDate=1/0,this.viewDate&&this.update()},getLocalDate:function(){if(this._unset)return null;var t=this._date;return new Date(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate(),t.getUTCHours(),t.getUTCMinutes(),t.getUTCSeconds(),t.getUTCMilliseconds())},setLocalDate:function(t){t?this.setValue(Date.UTC(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds())):this.setValue(null)},place:function(){var t="fixed",e=this.component?this.component.offset():this.$element.offset();this.width=this.component?this.component.outerWidth():this.$element.outerWidth(),e.top=e.top+this.height;var i=w(window);null!=this.options.width&&this.widget.width(this.options.width),"left"==this.options.orientation&&(this.widget.addClass("left-oriented"),e.left=e.left-this.widget.width()+20),this._isInFixed()&&(t="fixed",e.top-=i.scrollTop(),e.left-=i.scrollLeft()),i.width()<e.left+this.widget.outerWidth()?(e.right=i.width()-e.left-this.width,e.left="auto",this.widget.addClass("pull-right")):(e.right="auto",this.widget.removeClass("pull-right")),this.widget.css({position:t,top:e.top,left:e.left,right:e.right})},notifyChange:function(){this.$element.trigger({type:"changeDate",date:this.getDate(),localDate:this.getLocalDate()})},update:function(t){var e=t;if(!e&&((e=this.isInput?this.$element.val():this.$element.find("input").val())&&(this._date=this.parseDate(e)),!this._date)){var i=new Date;this._date=v(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours(),i.getMinutes(),i.getSeconds(),i.getMilliseconds())}this.viewDate=v(this._date.getUTCFullYear(),this._date.getUTCMonth(),1,0,0,0,0),this.fillDate(),this.fillTime()},fillDow:function(){for(var t=this.weekStart,e=w("<tr>");t<this.weekStart+7;)e.append('<th class="dow">'+k[this.language].daysMin[t++%7]+"</th>");this.widget.find(".datepicker-days thead").append(e)},fillMonths:function(){for(var t="",e=0;e<12;)t+='<span class="month">'+k[this.language].monthsShort[e++]+"</span>";this.widget.find(".datepicker-months td").append(t)},fillDate:function(){var t=this.viewDate.getUTCFullYear(),e=this.viewDate.getUTCMonth(),i=v(this._date.getUTCFullYear(),this._date.getUTCMonth(),this._date.getUTCDate(),0,0,0,0),s="object"==typeof this.startDate?this.startDate.getUTCFullYear():-1/0,a="object"==typeof this.startDate?this.startDate.getUTCMonth():-1,n="object"==typeof this.endDate?this.endDate.getUTCFullYear():1/0,o="object"==typeof this.endDate?this.endDate.getUTCMonth():12;this.widget.find(".datepicker-days").find(".disabled").removeClass("disabled"),this.widget.find(".datepicker-months").find(".disabled").removeClass("disabled"),this.widget.find(".datepicker-years").find(".disabled").removeClass("disabled"),this.widget.find(".datepicker-days th:eq(1)").text(k[this.language].months[e]+" "+t);var r=v(t,e-1,28,0,0,0,0),d=T.getDaysInMonth(r.getUTCFullYear(),r.getUTCMonth());r.setUTCDate(d),r.setUTCDate(d-(r.getUTCDay()-this.weekStart+7)%7),(t==s&&e<=a||t<s)&&this.widget.find(".datepicker-days th:eq(0)").addClass("disabled"),(t==n&&o<=e||n<t)&&this.widget.find(".datepicker-days th:eq(2)").addClass("disabled");var h=new Date(r.valueOf());h.setUTCDate(h.getUTCDate()+42),h=h.valueOf();for(var c,l,p=[];r.valueOf()<h;)r.getUTCDay()===this.weekStart&&(c=w("<tr>"),p.push(c)),l="",r.getUTCFullYear()<t||r.getUTCFullYear()==t&&r.getUTCMonth()<e?l+=" old":(r.getUTCFullYear()>t||r.getUTCFullYear()==t&&r.getUTCMonth()>e)&&(l+=" new"),r.valueOf()===i.valueOf()&&(l+=" active"),r.valueOf()+864e5<=this.startDate&&(l+=" disabled"),r.valueOf()>this.endDate&&(l+=" disabled"),c.append('<td class="day'+l+'">'+r.getUTCDate()+"</td>"),r.setUTCDate(r.getUTCDate()+1);this.widget.find(".datepicker-days tbody").empty().append(p);var u=this._date.getUTCFullYear(),f=this.widget.find(".datepicker-months").find("th:eq(1)").text(t).end().find("span").removeClass("active");u===t&&f.eq(this._date.getUTCMonth()).addClass("active"),u-1<s&&this.widget.find(".datepicker-months th:eq(0)").addClass("disabled"),n<u+1&&this.widget.find(".datepicker-months th:eq(2)").addClass("disabled");for(var m=0;m<12;m++)t==s&&m<a||t<s?w(f[m]).addClass("disabled"):(t==n&&o<m||n<t)&&w(f[m]).addClass("disabled");p="",t=10*parseInt(t/10,10);var g=this.widget.find(".datepicker-years").find("th:eq(1)").text(t+"-"+(t+9)).end().find("td");this.widget.find(".datepicker-years").find("th").removeClass("disabled"),t<s&&this.widget.find(".datepicker-years").find("th:eq(0)").addClass("disabled"),n<t+9&&this.widget.find(".datepicker-years").find("th:eq(2)").addClass("disabled"),t-=1;for(m=-1;m<11;m++)p+='<span class="year'+(-1===m||10===m?" old":"")+(u===t?" active":"")+(t<s||n<t?" disabled":"")+'">'+t+"</span>",t+=1;g.html(p)},fillHours:function(){var t=this.widget.find(".timepicker .timepicker-hours table");t.parent().hide();var e="";if(this.options.pick12HourFormat)for(var i=1,s=0;s<3;s+=1){e+="<tr>";for(var a=0;a<4;a+=1){e+='<td class="hour">'+o(i.toString(),2,"0")+"</td>",i++}e+="</tr>"}else for(i=0,s=0;s<6;s+=1){e+="<tr>";for(a=0;a<4;a+=1){e+='<td class="hour">'+o(i.toString(),2,"0")+"</td>",i++}e+="</tr>"}t.html(e)},fillMinutes:function(){var t=this.widget.find(".timepicker .timepicker-minutes table");t.parent().hide();for(var e="",i=0,s=0;s<5;s++){e+="<tr>";for(var a=0;a<4;a+=1){e+='<td class="minute">'+o(i.toString(),2,"0")+"</td>",i+=3}e+="</tr>"}t.html(e)},fillSeconds:function(){var t=this.widget.find(".timepicker .timepicker-seconds table");t.parent().hide();for(var e="",i=0,s=0;s<5;s++){e+="<tr>";for(var a=0;a<4;a+=1){e+='<td class="second">'+o(i.toString(),2,"0")+"</td>",i+=3}e+="</tr>"}t.html(e)},fillTime:function(){if(this._date){var t=this.widget.find(".timepicker span[data-time-component]"),e=(t.closest("table"),this.options.pick12HourFormat),i=this._date.getUTCHours(),s="AM";e&&(12<=i&&(s="PM"),0===i?i=12:12!=i&&(i%=12),this.widget.find(".timepicker [data-action=togglePeriod]").text(s)),i=o(i.toString(),2,"0");var a=o(this._date.getUTCMinutes().toString(),2,"0"),n=o(this._date.getUTCSeconds().toString(),2,"0");t.filter("[data-time-component=hours]").text(i),t.filter("[data-time-component=minutes]").text(a),t.filter("[data-time-component=seconds]").text(n)}},click:function(t){t.stopPropagation(),t.preventDefault(),this._unset=!1;var e=w(t.target).closest("span, td, th");if(1===e.length&&!e.is(".disabled"))switch(e[0].nodeName.toLowerCase()){case"th":switch(e[0].className){case"switch":this.showMode(1);break;case"prev":case"next":var i=this.viewDate,s=T.modes[this.viewMode].navFnc,a=T.modes[this.viewMode].navStep;"prev"===e[0].className&&(a*=-1),i["set"+s](i["get"+s]()+a),this.fillDate(),this.set()}break;case"span":if(e.is(".month")){var n=e.parent().find("span").index(e);this.viewDate.setUTCMonth(n)}else{var o=parseInt(e.text(),10)||0;this.viewDate.setUTCFullYear(o)}0!==this.viewMode&&(this._date=v(this.viewDate.getUTCFullYear(),this.viewDate.getUTCMonth(),this.viewDate.getUTCDate(),this._date.getUTCHours(),this._date.getUTCMinutes(),this._date.getUTCSeconds(),this._date.getUTCMilliseconds()),this.notifyChange()),this.showMode(-1),this.fillDate(),this.set();break;case"td":if(e.is(".day")){var r=parseInt(e.text(),10)||1;n=this.viewDate.getUTCMonth(),o=this.viewDate.getUTCFullYear();e.is(".old")?0===n?(n=11,o-=1):n-=1:e.is(".new")&&(11==n?(n=0,o+=1):n+=1),this._date=v(o,n,r,this._date.getUTCHours(),this._date.getUTCMinutes(),this._date.getUTCSeconds(),this._date.getUTCMilliseconds()),this.viewDate=v(o,n,Math.min(28,r),0,0,0,0),this.fillDate(),this.set(),this.notifyChange()}}},actions:{incrementHours:function(t){this._date.setUTCHours(this._date.getUTCHours()+1)},incrementMinutes:function(t){this._date.setUTCMinutes(this._date.getUTCMinutes()+1)},incrementSeconds:function(t){this._date.setUTCSeconds(this._date.getUTCSeconds()+1)},decrementHours:function(t){this._date.setUTCHours(this._date.getUTCHours()-1)},decrementMinutes:function(t){this._date.setUTCMinutes(this._date.getUTCMinutes()-1)},decrementSeconds:function(t){this._date.setUTCSeconds(this._date.getUTCSeconds()-1)},togglePeriod:function(t){var e=this._date.getUTCHours();12<=e?e-=12:e+=12,this._date.setUTCHours(e)},showPicker:function(){this.widget.find(".timepicker > div:not(.timepicker-picker)").hide(),this.widget.find(".timepicker .timepicker-picker").show()},showHours:function(){this.widget.find(".timepicker .timepicker-picker").hide(),this.widget.find(".timepicker .timepicker-hours").show()},showMinutes:function(){this.widget.find(".timepicker .timepicker-picker").hide(),this.widget.find(".timepicker .timepicker-minutes").show()},showSeconds:function(){this.widget.find(".timepicker .timepicker-picker").hide(),this.widget.find(".timepicker .timepicker-seconds").show()},selectHour:function(t){var e=w(t.target),i=parseInt(e.text(),10);this.options.pick12HourFormat&&(12<=this._date.getUTCHours()?12!=i&&(i=(i+12)%24):12===i?i=0:i%=12);this._date.setUTCHours(i),this.actions.showPicker.call(this)},selectMinute:function(t){var e=w(t.target),i=parseInt(e.text(),10);this._date.setUTCMinutes(i),this.actions.showPicker.call(this)},selectSecond:function(t){var e=w(t.target),i=parseInt(e.text(),10);this._date.setUTCSeconds(i),this.actions.showPicker.call(this)}},doAction:function(t){t.stopPropagation(),t.preventDefault(),this._date||(this._date=v(1970,0,0,0,0,0,0));var e=w(t.currentTarget).data("action"),i=this.actions[e].apply(this,arguments);return this.set(),this.fillTime(),this.notifyChange(),i},stopEvent:function(t){t.stopPropagation(),t.preventDefault()},keydown:function(t){var e=this,i=t.which,s=w(t.target);8!=i&&46!=i||setTimeout(function(){e._resetMaskPos(s)})},keypress:function(t){var e=t.which;if(8!=e&&46!=e){var i=w(t.target),s=String.fromCharCode(e),a=i.val()||"";a+=s;var n=this._mask[this._maskPos];if(!n)return!1;if(n.end==a.length){if(!n.pattern.test(a.slice(n.start))){for(a=a.slice(0,a.length-1);(n=this._mask[this._maskPos])&&n.character;)a+=n.character,this._maskPos++;return a+=s,n.end!=a.length?i.val(a):n.pattern.test(a.slice(n.start))?(i.val(a),this._maskPos++):i.val(a.slice(0,n.start)),!1}this._maskPos++}}},change:function(t){var e=w(t.target),i=e.val();this._formatPattern.test(i)?(this.update(),this.setValue(this._date.getTime()),this.notifyChange(),this.set()):i&&i.trim()?(this.setValue(this._date.getTime()),this._date?this.set():e.val("")):this._date&&(this.setValue(null),this.notifyChange(),this._unset=!0),this._resetMaskPos(e)},showMode:function(t){t&&(this.viewMode=Math.max(this.minViewMode,Math.min(2,this.viewMode+t))),this.widget.find(".datepicker > div").hide().filter(".datepicker-"+T.modes[this.viewMode].clsName).show()},destroy:function(){this._detachDatePickerEvents(),this._detachDatePickerGlobalEvents(),this.widget.remove(),this.$element.removeData("datetimepicker"),this.component.removeData("datetimepicker")},formatDate:function(n){return this.format.replace(s,function(t){var e,i,s,a=t.length;if("ms"===t&&(a=1),"Hours12"===(i=d[t].property))0===(s=n.getUTCHours())?s=12:12!==s&&(s%=12);else{if("Period12"===i)return 12<=n.getUTCHours()?"PM":"AM";s=n[e="get"+i]()}return"getUTCMonth"===e&&(s+=1),"getUTCYear"===e&&(s=s+1900-2e3),o(s.toString(),a,"0")})},parseDate:function(t){var e,i,s,a,n={};if(!(e=this._formatPattern.exec(t)))return null;for(i=1;i<e.length;i++)(s=this._propertiesByIndex[i])&&(a=e[i],/^\d+$/.test(a)&&(a=parseInt(a,10)),n[s]=a);return this._finishParsingDate(n)},_resetMaskPos:function(t){for(var e=t.val(),i=0;i<this._mask.length;i++){if(this._mask[i].end>e.length){this._maskPos=i;break}if(this._mask[i].end===e.length){this._maskPos=i+1;break}}},_finishParsingDate:function(t){var e,i,s,a,n,o,r;return e=t.UTCFullYear,t.UTCYear&&(e=2e3+t.UTCYear),e||(e=1970),i=t.UTCMonth?t.UTCMonth-1:0,s=t.UTCDate||1,a=t.UTCHours||0,n=t.UTCMinutes||0,o=t.UTCSeconds||0,r=t.UTCMilliseconds||0,t.Hours12&&(a=t.Hours12),t.Period12&&(/pm/i.test(t.Period12)?12!=a&&(a=(a+12)%24):a%=12),v(e,i,s,a,n,o,r)},_compileFormat:function(){for(var t,e,i=[],s=[],a=this.format,n={},o=0,r=0;t=h.exec(a);)(e=t[0])in d?(n[++o]=d[e].property,i.push("\\s*"+d[e].getPattern(this)+"\\s*"),s.push({pattern:new RegExp(d[e].getPattern(this)),property:d[e].property,start:r,end:r+=e.length})):(i.push(c(e)),s.push({pattern:new RegExp(c(e)),character:e,start:r,end:++r})),a=a.slice(e.length);this._mask=s,this._maskPos=0,this._formatPattern=new RegExp("^\\s*"+i.join("")+"\\s*$"),this._propertiesByIndex=n},_attachDatePickerEvents:function(){var o=this;this.widget.on("click",".datepicker *",w.proxy(this.click,this)),this.widget.on("click","[data-action]",w.proxy(this.doAction,this)),this.widget.on("mousedown",w.proxy(this.stopEvent,this)),this.pickDate&&this.pickTime&&this.widget.on("click.togglePicker",".accordion-toggle",function(t){t.stopPropagation();var e=w(this),i=e.closest("ul"),s=i.find(".collapse.in"),a=i.find(".collapse:not(.in)");if(s&&s.length){var n=s.data("collapse");if(n&&n.transitioning)return;s.css("height","0px").removeClass("in"),a.css("height","auto").addClass("in"),e.find("i").toggleClass(o.timeIcon+" "+o.dateIcon),o.$element.find(".add-on i").toggleClass(o.timeIcon+" "+o.dateIcon)}}),this.isInput?(this.$element.on({focus:w.proxy(this.show,this),change:w.proxy(this.change,this)}),this.options.maskInput&&this.$element.on({keydown:w.proxy(this.keydown,this),keypress:w.proxy(this.keypress,this)})):(this.$element.on({change:w.proxy(this.change,this)},"input"),this.options.maskInput&&this.$element.on({keydown:w.proxy(this.keydown,this),keypress:w.proxy(this.keypress,this)},"input"),this.component?this.component.on("click",w.proxy(this.show,this)):this.$element.on("click",w.proxy(this.show,this)))},_attachDatePickerGlobalEvents:function(){w(window).on("resize.datetimepicker"+this.id,w.proxy(this.place,this)),this.isInput||w(document).on("mousedown.datetimepicker"+this.id,w.proxy(this.hide,this))},_detachDatePickerEvents:function(){this.widget.off("click",".datepicker *",this.click),this.widget.off("click","[data-action]"),this.widget.off("mousedown",this.stopEvent),this.pickDate&&this.pickTime&&this.widget.off("click.togglePicker"),this.isInput?(this.$element.off({focus:this.show,change:this.change}),this.options.maskInput&&this.$element.off({keydown:this.keydown,keypress:this.keypress})):(this.$element.off({change:this.change},"input"),this.options.maskInput&&this.$element.off({keydown:this.keydown,keypress:this.keypress},"input"),this.component?this.component.off("click",this.show):this.$element.off("click",this.show))},_detachDatePickerGlobalEvents:function(){w(window).off("resize.datetimepicker"+this.id),this.isInput||w(document).off("mousedown.datetimepicker"+this.id)},_isInFixed:function(){if(this.$element){for(var t=this.$element.parents(),e=!1,i=0;i<t.length;i++)if("fixed"==w(t[i]).css("position")){e=!0;break}return e}return!1}},w.fn.datetimepicker=function(s,a){return this.each(function(){var t=w(this),e=t.data("datetimepicker"),i="object"==typeof s&&s;e||t.data("datetimepicker",e=new n(this,w.extend({},w.fn.datetimepicker.defaults,i))),"string"==typeof s&&e[s](a)})},w.fn.datetimepicker.defaults={maskInput:!1,pickDate:!0,pickTime:!0,pick12HourFormat:!1,pickSeconds:!0,startDate:-1/0,endDate:1/0,collapse:!0},w.fn.datetimepicker.Constructor=n;var i=0,k=w.fn.datetimepicker.dates={en:{days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"],daysShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sun"],daysMin:["Su","Mo","Tu","We","Th","Fr","Sa","Su"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],monthsShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]}},d={dd:{property:"UTCDate",getPattern:function(){return"(0?[1-9]|[1-2][0-9]|3[0-1])\\b"}},MM:{property:"UTCMonth",getPattern:function(){return"(0?[1-9]|1[0-2])\\b"}},yy:{property:"UTCYear",getPattern:function(){return"(\\d{2})\\b"}},yyyy:{property:"UTCFullYear",getPattern:function(){return"(\\d{4})\\b"}},hh:{property:"UTCHours",getPattern:function(){return"(0?[0-9]|1[0-9]|2[0-3])\\b"}},mm:{property:"UTCMinutes",getPattern:function(){return"(0?[0-9]|[1-5][0-9])\\b"}},ss:{property:"UTCSeconds",getPattern:function(){return"(0?[0-9]|[1-5][0-9])\\b"}},ms:{property:"UTCMilliseconds",getPattern:function(){return"([0-9]{1,3})\\b"}},HH:{property:"Hours12",getPattern:function(){return"(0?[1-9]|1[0-2])\\b"}},PP:{property:"Period12",getPattern:function(){return"(AM|PM|am|pm|Am|aM|Pm|pM)\\b"}}},t=[];for(var e in d)t.push(e);t[t.length-1]+="\\b",t.push(".");var h=new RegExp(t.join("\\b|"));t.pop();var s=new RegExp(t.join("\\b|"),"g");function c(t){return t.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")}function o(t,e,i){return e<t.length?t:Array(e-t.length+1).join(i||" ")+t}function v(){return new Date(Date.UTC.apply(Date,arguments))}var T={modes:[{clsName:"days",navFnc:"UTCMonth",navStep:1},{clsName:"months",navFnc:"UTCFullYear",navStep:1},{clsName:"years",navFnc:"UTCFullYear",navStep:10}],isLeapYear:function(t){return t%4==0&&t%100!=0||t%400==0},getDaysInMonth:function(t,e){return[31,T.isLeapYear(t)?29:28,31,30,31,30,31,31,30,31,30,31][e]},headTemplate:'<thead><tr><th class="prev">&lsaquo;</th><th colspan="5" class="switch"></th><th class="next">&rsaquo;</th></tr></thead>',contTemplate:'<tbody><tr><td colspan="7"></td></tr></tbody>'};T.template='<div class="datepicker-days"><table class="table-condensed">'+T.headTemplate+'<tbody></tbody></table></div><div class="datepicker-months"><table class="table-condensed">'+T.headTemplate+T.contTemplate+'</table></div><div class="datepicker-years"><table class="table-condensed">'+T.headTemplate+T.contTemplate+"</table></div>";var l={hourTemplate:'<span data-action="showHours" data-time-component="hours" class="timepicker-hour"></span>',minuteTemplate:'<span data-action="showMinutes" data-time-component="minutes" class="timepicker-minute"></span>',secondTemplate:'<span data-action="showSeconds" data-time-component="seconds" class="timepicker-second"></span>',getTemplate:function(t,e){return'<div class="timepicker-picker"><table class="table-condensed"'+(t?' data-hour-format="12"':"")+'><tr><td><a href="#" class="btn" data-action="incrementHours"><i class="bdticon-arrow-up"></i></a></td><td class="separator"></td><td><a href="#" class="btn" data-action="incrementMinutes"><i class="bdticon-arrow-up"></i></a></td>'+(e?'<td class="separator"></td><td><a href="#" class="btn" data-action="incrementSeconds"><i class="bdticon-arrow-up"></i></a></td>':"")+(t?'<td class="separator"></td>':"")+"</tr><tr><td>"+l.hourTemplate+'</td> <td class="separator">:</td><td>'+l.minuteTemplate+"</td> "+(e?'<td class="separator">:</td><td>'+l.secondTemplate+"</td>":"")+(t?'<td class="separator"></td><td><button type="button" class="btn btn-primary" data-action="togglePeriod"></button></td>':"")+'</tr><tr><td><a href="#" class="btn" data-action="decrementHours"><i class="bdticon-arrow-down"></i></a></td><td class="separator"></td><td><a href="#" class="btn" data-action="decrementMinutes"><i class="bdticon-arrow-down"></i></a></td>'+(e?'<td class="separator"></td><td><a href="#" class="btn" data-action="decrementSeconds"><i class="bdticon-arrow-down"></i></a></td>':"")+(t?'<td class="separator"></td>':"")+'</tr></table></div><div class="timepicker-hours" data-action="selectHour"><table class="table-condensed"></table></div><div class="timepicker-minutes" data-action="selectMinute"><table class="table-condensed"></table></div>'+(e?'<div class="timepicker-seconds" data-action="selectSecond"><table class="table-condensed"></table></div>':"")}};jQuery(document).ready(function(){jQuery(".ult-datetime").datetimepicker({format:"yyyy/MM/dd hh:mm:ss",autoclose:!0,showClose:!0,todayBtn:!0,startDate:"2016-01-01 00:00",minuteStep:10})}),jQuery(".ult-datetime").on("show",function(t){return t.preventDefault(),!1}).datetimepicker()}(window.jQuery);