/*!
 * Particleground
 *
 * @author Jonathan Nicol - @mrjnicol
 * @version 1.1.0
 * @description Creates a canvas based particle system background
 *
 * Inspired by http://requestlab.fr/ and http://disruptivebydesign.com/
 */
!function(O,S){"use strict";var M="particleground";var w=O.jQuery;function s(o,n){var r,s,i,a,h,p,l=!!S.createElement("canvas").getContext,d=[],f=0,x=0,c=!navigator.userAgent.match(/(iPhone|iPod|iPad|Android|BlackBerry|BB10|mobi|tablet|opera mini|nexus 7)/i),u=!!O.DeviceOrientationEvent,y=0,m=0,e=!1;function g(){r.width=o.offsetWidth,r.height=o.offsetHeight,s.fillStyle=n.dotColor,s.strokeStyle=n.lineColor,s.lineWidth=n.lineWidth}function v(){if(l){i=O.innerWidth,a=O.innerHeight,s.clearRect(0,0,r.width,r.height);for(var t=0;t<d.length;t++)d[t].updatePosition();for(t=0;t<d.length;t++)d[t].draw();e||requestAnimationFrame(v)}}function X(){switch(this.stackPos,this.active=!0,this.layer=Math.ceil(3*Math.random()),this.parallaxOffsetX=0,this.parallaxOffsetY=0,this.position={x:Math.ceil(Math.random()*r.width),y:Math.ceil(Math.random()*r.height)},this.speed={},n.directionX){case"left":this.speed.x=+(-n.maxSpeedX+Math.random()*n.maxSpeedX-n.minSpeedX).toFixed(2);break;case"right":this.speed.x=+(Math.random()*n.maxSpeedX+n.minSpeedX).toFixed(2);break;default:this.speed.x=+(-n.maxSpeedX/2+Math.random()*n.maxSpeedX).toFixed(2),this.speed.x+=0<this.speed.x?n.minSpeedX:-n.minSpeedX}switch(n.directionY){case"up":this.speed.y=+(-n.maxSpeedY+Math.random()*n.maxSpeedY-n.minSpeedY).toFixed(2);break;case"down":this.speed.y=+(Math.random()*n.maxSpeedY+n.minSpeedY).toFixed(2);break;default:this.speed.y=+(-n.maxSpeedY/2+Math.random()*n.maxSpeedY).toFixed(2),this.speed.x+=0<this.speed.y?n.minSpeedY:-n.minSpeedY}}function Y(t){void 0!==n[t]&&n[t].call(o)}return n=function(t){t=t||{};for(var e=1;e<arguments.length;e++){var i=arguments[e];if(i)for(var a in i)i.hasOwnProperty(a)&&("object"==typeof i[a]?deepExtend(t[a],i[a]):t[a]=i[a])}return t}({},O[M].defaults,n),X.prototype.draw=function(){s.beginPath(),s.arc(this.position.x+this.parallaxOffsetX,this.position.y+this.parallaxOffsetY,n.particleRadius/2,0,2*Math.PI,!0),s.closePath(),s.fill(),s.beginPath();for(var t=d.length-1;t>this.stackPos;t--){var e=d[t],i=this.position.x-e.position.x,a=this.position.y-e.position.y;Math.sqrt(i*i+a*a).toFixed(2)<n.proximity&&(s.moveTo(this.position.x+this.parallaxOffsetX,this.position.y+this.parallaxOffsetY),n.curvedLines?s.quadraticCurveTo(Math.max(e.position.x,e.position.x),Math.min(e.position.y,e.position.y),e.position.x+e.parallaxOffsetX,e.position.y+e.parallaxOffsetY):s.lineTo(e.position.x+e.parallaxOffsetX,e.position.y+e.parallaxOffsetY))}s.stroke(),s.closePath()},X.prototype.updatePosition=function(){if(n.parallax){if(u&&!c)h=(y- -30)*((i-0)/60)+0,p=(m- -30)*((a-0)/60)+0;else h=f,p=x;this.parallaxTargX=(h-i/2)/(n.parallaxMultiplier*this.layer),this.parallaxOffsetX+=(this.parallaxTargX-this.parallaxOffsetX)/10,this.parallaxTargY=(p-a/2)/(n.parallaxMultiplier*this.layer),this.parallaxOffsetY+=(this.parallaxTargY-this.parallaxOffsetY)/10}var t=o.offsetWidth,e=o.offsetHeight;switch(n.directionX){case"left":this.position.x+this.speed.x+this.parallaxOffsetX<0&&(this.position.x=t-this.parallaxOffsetX);break;case"right":this.position.x+this.speed.x+this.parallaxOffsetX>t&&(this.position.x=0-this.parallaxOffsetX);break;default:(this.position.x+this.speed.x+this.parallaxOffsetX>t||this.position.x+this.speed.x+this.parallaxOffsetX<0)&&(this.speed.x=-this.speed.x)}switch(n.directionY){case"up":this.position.y+this.speed.y+this.parallaxOffsetY<0&&(this.position.y=e-this.parallaxOffsetY);break;case"down":this.position.y+this.speed.y+this.parallaxOffsetY>e&&(this.position.y=0-this.parallaxOffsetY);break;default:(this.position.y+this.speed.y+this.parallaxOffsetY>e||this.position.y+this.speed.y+this.parallaxOffsetY<0)&&(this.speed.y=-this.speed.y)}this.position.x+=this.speed.x,this.position.y+=this.speed.y},X.prototype.setStackPos=function(t){this.stackPos=t},function(){if(l){(r=S.createElement("canvas")).className="pg-canvas",r.style.display="block",o.insertBefore(r,o.firstChild),s=r.getContext("2d"),g();for(var t=Math.round(r.width*r.height/n.density),e=0;e<t;e++){var i=new X;i.setStackPos(e),d.push(i)}O.addEventListener("resize",function(){!function(){g();for(var t=o.offsetWidth,e=o.offsetHeight,i=d.length-1;0<=i;i--)(d[i].position.x>t||d[i].position.y>e)&&d.splice(i,1);var a=Math.round(r.width*r.height/n.density);if(a>d.length)for(;a>d.length;){var s=new X;d.push(s)}else a<d.length&&d.splice(a);for(i=d.length-1;0<=i;i--)d[i].setStackPos(i)}()},!1),O.addEventListener("load",function(){g()},!1),S.addEventListener("mousemove",function(t){f=t.pageX,x=t.pageY},!1),u&&!c&&O.addEventListener("deviceorientation",function(){m=Math.min(Math.max(-event.beta,-30),30),y=Math.min(Math.max(-event.gamma,-30),30)},!0),v(),Y("onInit")}}(),{option:function(t,e){if(!e)return n[t];n[t]=e},destroy:function(){console.log("destroy"),r.parentNode.removeChild(r),Y("onDestroy"),w&&w(o).removeData("plugin_"+M)},start:function(){e=!1,v()},pause:function(){e=!0}}}O[M]=function(t,e){return new s(t,e)},O[M].defaults={minSpeedX:.1,maxSpeedX:.7,minSpeedY:.1,maxSpeedY:.7,directionX:"center",directionY:"center",density:1e4,dotColor:"#666666",lineColor:"#666666",particleRadius:7,lineWidth:1,curvedLines:!1,proximity:100,parallax:!0,parallaxMultiplier:5,onInit:function(){},onDestroy:function(){}},w&&(w.fn[M]=function(t){if("string"==typeof t){var e,i=t,a=Array.prototype.slice.call(arguments,1);return this.each(function(){w.data(this,"plugin_"+M)&&"function"==typeof w.data(this,"plugin_"+M)[i]&&(e=w.data(this,"plugin_"+M)[i].apply(this,a))}),void 0!==e?e:this}if("object"==typeof t||!t)return this.each(function(){w.data(this,"plugin_"+M)||w.data(this,"plugin_"+M,new s(this,t))})})}(window,document),
													
/**
 * requestAnimationFrame polyfill by Erik Möller. fixes from Paul Irish and Tino Zijdel
 * @see: http://paulirish.com/2011/requestanimationframe-for-smart-animating/
 * @see: http://my.opera.com/emoller/blog/2011/12/20/requestanimationframe-for-smart-er-animating
 * @license: MIT license
 */
!function(){for(var t=0,n=["ms","moz","webkit","o"],i=0;i<n.length&&!window.requestAnimationFrame;++i)window.requestAnimationFrame=window[n[i]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[n[i]+"CancelAnimationFrame"]||window[n[i]+"CancelRequestAnimationFrame"];window.requestAnimationFrame||(window.requestAnimationFrame=function(n,i){var e=(new Date).getTime(),a=Math.max(0,16-(e-t)),o=window.setTimeout(function(){n(e+a)},a);return t=e+a,o}),window.cancelAnimationFrame||(window.cancelAnimationFrame=function(n){clearTimeout(n)})}();