/**
 * Stop an iframe or HTML5 <video> from playing
 * @param  {Element} element The element that contains the video
 */
var DFD_VideoModule = DFD_VideoModule || {};
(function($){
	var VideoModule_VimeoPlayer = function(iframe){
		var iframeEl = iframe;
		var tag = document.createElement('script');
		tag.src = "https://f.vimeocdn.com/js/froogaloop2.min.js";
		tag.id = "dfd-vimeo-api-script";
		var firstScriptTag = document.getElementsByTagName('script')[0];
		firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

		play = function(){
			var player = $f(iframeEl[0]);
			player.addEvent('ready', function(){
				player.api("play");
			});
		};
		setIframe = function(id){
			iframeEl = id;
		};
		var public = {
			setIframe: setIframe,
			play: play
		};
		return public;
	};
	var VideoModule_YoutubePlayer = function(iframe){
		var iframeEl = iframe;

		play = function(){
			/*$('.dfd-fullscreen-video-container iframe').each(function(){
				var player = $(this);
				player[0].src += '&autoplay=1';
			});*/
			iframeEl[0].src += '&autoplay=1';
		};
		setIframe = function(id){
			iframeEl = id;
		};
		var public = {
			setIframe: setIframe,
			play: play
		};
		return public;
	};

	DFD_VideoModule = {
		block_id: "",
		id: "",
		$video_container: "",
		iframe: [
		],
		player: [
		],
		getTypePlayer: function(href, iframe){
			if(!href || href == '' || href == '#'){
				alert('No valid video url were added in Video module settings. Please specify the valid video url');
				return;
			}

			var isVimeo = href.search("player.vimeo.com");
			if(isVimeo >= 0){
				this.player["#" + this.id] = new VideoModule_VimeoPlayer(iframe);
			} else {
				this.player["#" + this.id] = new VideoModule_YoutubePlayer(iframe);
			}
		},
		init: function(id, block_id){
			this.id = id;
			this.block_id = block_id;
			this.iframe["#" + id] = $("#" + id).find("iframe");
			var url = $(this.iframe["#" + id]).attr("src");
			this.getTypePlayer(url, this.iframe["#" + id]);
			this.addLightBox();
			this.addEvents();
		},
		addEvents: function(){
			var self = this;
			$("#" + this.block_id + " a.dfd-video-link").on("click", function(e){
				id = $(this).attr("href");
				e.preventDefault();
				var $animation = $(this).data("animation");
				/*self.$video_container.fadeIn('slow');
				$animation ? $animation : "none";
				console.log($animation);*/
				self.$video_container.find(".fluidvids").removeClass("LightBoxVideoModule_Hide");
				self.$video_container.fadeIn("slow").find(".fluidvids").removeClass("LightBoxVideoModule_Show");
				if($animation){
					self.$video_container.find(".fluidvids").velocity($animation, {display: 'auto'});
					self.$video_container.css("display", "block");
				} else {
					self.$video_container.find(".fluidvids").velocity("transition.slideUpBigIn", {display: 'auto'});
					self.$video_container.css("display", "block");
				}
/*				console.log(self.settings[id]);
				console.log(self.id);
				console.log(self.block_id);
				$(self.$video_container[0]).removeAttr("id");*/

				$(self.$video_container[0]).attr("id", id.replace("#", ""));
				/*$(self.$video_container[0]).prop(""+self.settings[id]+"");*/
				self.$video_container.find(".fluidvids").append(self.iframe[id]);
				self.player[id].play();

			});
			$("#" + this.block_id + " a.dfd-video-image-thumb").on("click", function(e){
				e.preventDefault();
				id = $(this).attr("href");
				$(this).parent().addClass('active');
				$(this).fadeOut('slow');
				self.player[id].play();

			});
			this.$video_container.find('a.fullscreen-video-close').on('click', function(e){
				e.preventDefault();
/*				self.$video_container.find(".fluidvids iframe").velocity("transition.slideDownBigIn", {display: 'none'});
				self.$video_container.find(".fluidvids").css({"transform": "translateY(50px)","opacity" : "0", "transition": "all .5s"})*/
				self.$video_container.find(".fluidvids").addClass("LightBoxVideoModule_Hide");
				setTimeout(function(){
					self.$video_container.fadeOut("slow").find('iframe').remove();
				}, 500);
			});
		},
		addLightBox: function(){
			if($('.dfd-fullscreen-video-container').length == 0){
				this.$video_container = $('<div class="dfd-fullscreen-video-container video_module" ><div class="fluidvids"></div><a href="#close-video" class="fullscreen-video-close">×</a></div>');
				this.$video_container.appendTo('body');
			} else {
				this.$video_container = $('.dfd-fullscreen-video-container');
			}
		}
	};
})(jQuery)