<?php
/**
 * Extansion version
 *
 * @package     Wow_Plugin
 * @subpackage
 * @copyright   Copyright (c) 2018, Dmytro Lobov
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$pro_url  = 'https://wow-estore.com/item/floating-button-pro/';
$demo_url = 'https://wow-company.com/floating-button-pro/';
?>

<section class="section has-background-light is-medium" id="features">
    <div class="container">
        <div class="block has-text-centered ds-title">
            <p class="subtitle is-5 is-uppercase has-text-danger">what you get</p>
            <h3 class="title is-2">Awesome Features </h3>
            <div class="button-group">
                <a href="<?php echo esc_url( $pro_url ); ?>" class="like-button pro-button" target="_blank">Get More
                    with Pro</a>
                <a href="<?php echo esc_url( $demo_url ); ?>" class="like-button demo-button" target="_blank">Demo</a>
            </div>
        </div>

        <div class="block py-5">
            <h3 class="features-title">Customize:</h3>
        </div>

        <div class="features-content">

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-swatchbook fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Beautiful Animations</h4>
                    <p>8 animations for showing sub buttons and 11 animations for the main button.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-shapes fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Different Shapes</h4>
                    <p>Choose different types of shapes for the menu: Square, Round, Rounded, Rounded-out.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-flag fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Icon Animation</h4>
                    <p>Set one of the 7 animations for the menu item icon.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-flag fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">1900+ Icons</h4>
                    <p>The current version of the plugin has 1900+ Font Awesome Icon.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-text-height fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Size control</h4>
                    <p>Set the 3 size for buttons: small, medium, large.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-arrows-alt-h fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Different Positions</h4>
                    <p>8 different Positions.</p>
                </div>
            </div>


            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-sun fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Shadow</h4>
                    <p>Enable or disable the menu shadow.</p>
                </div>
            </div>


            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-image fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Custom Icon</h4>
                    <p>Add your own icon for the menu item.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-font fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Tooltip</h4>
                    <p>Set the tooltip text for button.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-door-open fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Hold open</h4>
                    <p>Hold the buttons open.</p>
                </div>
            </div>


            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-plus fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Add Attributes</h4>
                    <p>Add custom values to attributes such as CLASS and ID to each menu
                        item.</p>
                </div>
            </div>


        </div>

        <div class="block py-5">
            <h3 class="features-title">Functionality:</h3>
        </div>

        <div class="features-content">

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-language fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Translate</h4>
                    <p>Translate page on different languages.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-share-alt fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">33 Social Share</h4>
                    <p>33 Easy Social Share Buttons for WordPress.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-exchange-alt fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Next, Previous post</h4>
                    <p>Set the link to the link of the next and previous post.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-bars fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Menu</h4>
                    <p>Open menu into the popup.</p>
                </div>
            </div>


            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-arrows-alt-v fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Smooth Scroll</h4>
                    <p>Create a smooth scrolling effect to the page anchors.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-long-arrow-alt-up fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Go To Top</h4>
                    <p>Create a button that will take the user to the top of the page
                        when clicked on.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-long-arrow-alt-down fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Go To Bottom</h4>
                    <p>Create a button that will take the user to the bottom of the page
                        when clicked on.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-long-arrow-alt-left fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Go Back</h4>
                    <p>Create a button that will take the user to the previous URL in the
                        history list.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-long-arrow-alt-right fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Go Forward</h4>
                    <p>Create a button that will take the user to the next URL in the
                        history list.</p>
                </div>
            </div>


            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-print fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Print</h4>
                    <p>Function for print the page via a click on the item.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-users-cog fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">User links</h4>
                    <p>Built-in user links: LogIn, LogOut, Register, Lostpassword.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-window-restore fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">New Window</h4>
                    <p>Opening link in new window.</p>
                </div>
            </div>

        </div>

        <div class="block py-5">
            <h3 class="features-title">Display:</h3>
        </div>

        <div class="features-content">

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-tablet-alt fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Show on devices</h4>
                    <p>Control over the display of the menu on different devices.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-users fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Show for users</h4>
                    <p>Show menu depending on user (for all users, only for logged-in users, only for not logged-in users).</p>
                </div>
            </div>


            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-language fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Language dependence</h4>
                    <p>Show menu depending on language.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-calendar-alt fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Schedule</h4>
                    <p>Show your menu according to the schedule, indicating the date, day of the week, and hours
                        .</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-globe fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Browsers</h4>
                    <p>Ability to deactivate the display of popups in selected browsers.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-file-alt fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Specific pages</h4>
                    <p>Show the menu on the specific pages.</p>
                </div>
            </div>
        </div>


    </div>

</section>

